/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.
//
// And then further adapted to optimise it somewhat.  The improvement, while not
// huge, made a noticable difference with one of my more complex scenes. TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// Created by Daniel Burke - burito/2014
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

// Inspiration from Dr Who (2005) S7E13 - The Name of the Doctor

// The ring (previously called circle) and disc functions have been
// replaced by equivalent macros for efficiency. Full clamping does
// not seem to be needed so I have replaced clamp with max. TheEmu.

#define ring(lp,r)  max ( 0.0, ( 0.011 - abs(lp-r)) * 100.0 )
#define disc(lp,r)  max ( 0.0, ( 0.011 -    (lp-r)) * 100.0 )

// I have not replaced the line function with a macro as that would
// be rather unweildy, I have replaced one clamp with max. TheEmu.

float line ( in vec2 p, in vec2 a, in vec2 b ) // Thanks Inigo Quilez!
 {
   vec2 ba = a - b;
   vec2 pa = p + a;

   float h = clamp ( dot(pa,ba) / dot(ba,ba), 0.0, 1.0 );
   float d = length ( pa - ba*h );

   return max ( (0.01-d)*100.0, 0.0 );
 }

const vec3 colour = vec3(1.0);

const vec2 p0 = vec2 ( 0.00000,  0.00000 );
const vec2 p1 = vec2 ( 1.00000,  0.00000 ) * 0.46;
const vec2 p2 = vec2 ( 0.84147,  0.54030 ) * 0.46;
const vec2 p3 = vec2 ( 0.84147, -0.54030 ) * 0.46;
const vec2 p4 = vec2 ( 0.41614,  0.90929 ) * 0.46;
const vec2 p5 = vec2 ( 0.41614, -0.90929 ) * 0.46;
const vec2 p6 = vec2 ( 0.08500,  0.08500 );
const vec2 p7 = vec2 ( 0.00010,  0.50000 );
const vec2 p8 = vec2 ( 0.00100, -0.50000 );
const vec2 p9 = vec2 ( 0.00100,  0.50000 );

void main(void)
 {

   vec2 p = (gl_FragCoord.xy/iResolution.xy)*2.0 - 1.0;
   p.x = p.x * iResolution.x/iResolution.y;

   float lp = length(p);

   float q = 0.0;

   // Don't waste time where nothing can ever appear.

   if ( lp < 1.25 )
    {
      float t01 = iGlobalTime;
      float t02 = t01 *  0.50;
      float t03 = t01 * -0.01;
      float t04 = t01 *  0.03;
      float t05 = t04           +  4.0;
      float t06 = t02 * -0.10   +  5.0;
      float t07 = t02 *  1.40;
      float t08 = t07 *  0.80;
      float t09 = t02           +  3.0;
      float t10 = t01           +  0.001;

      float tma07 = mod(t07,0.5);
      float tmb07 = tma07 - 0.4;

      float tma08 = mod(t08,0.6);
      float tmb08 = tma08 - 0.2;

      float tma09 = mod(t09,0.2);
      float tmb09 = tma09 - 0.1;

      float tma10 = mod(t10,1.0);
      float tmb10 = tma10 - 0.9;

      float tmt07 = t07 - tma07 + ( ( tmb07 > 0.0 ) ? tmb07 *  5.0 : 0.0 );
      float tmt80 = t08 - tma08 + ( ( tmb08 > 0.0 ) ? tmb08 *  1.5 : 0.0 );
      float tmt90 = tma09 - t09 - ( ( tmb09 > 0.0 ) ? tmb09 *  2.0 : 0.0 );
      float tmt10 = tma10 - t10 - ( ( tmb10 > 0.0 ) ? tmb10 * 10.0 : 0.0 );

      float tmt11 = tmt10 - 1.0471975511965976;
      float tmt12 = tmt11 - 1.0471975511965976;

      float tmt81 = tmt80 * 4.0;
      float tmt91 = tmt90 - 0.9;
      float tmt92 = tmt91 - 0.5;
      float tmt93 = tmt92 - 0.5;
      float tmt94 = tmt93 - 0.5;
      float tmt95 = tmt94 - 0.5;

      vec2 angle1 = vec2 ( sin(t01), cos(t01) );
      vec2 angle2 = vec2 ( sin(t02), cos(t02) );
      vec2 angle3 = vec2 ( sin(t03), cos(t03) );
      vec2 angle4 = vec2 ( sin(t04), cos(t04) );
      vec2 angle5 = vec2 ( sin(t05), cos(t05) );
      vec2 angle6 = vec2 ( sin(t06), cos(t06) );

      vec2 angle1a = angle1 * 0.06;

      vec2 a  = angle1 * 0.70;
      vec2 b  = angle2 * 0.80;
      vec2 c  = angle3 * 0.40   +   b;
      vec2 d  = angle4 * 0.90;
      vec2 e  = angle5 * 0.80;
      vec2 f  = angle6 * 0.80;

      vec2 tangle1 = vec2 ( sin(tmt07), cos(tmt07) );
      vec2 tangle2 = vec2 ( sin(tmt81), cos(tmt81) );
      vec2 tangle3 = vec2 ( sin(tmt80), cos(tmt80) ) * 0.2;

      vec2 tangle40 = vec2(sin(tmt90),cos(tmt90))*0.16;
      vec2 tangle41 = vec2(sin(tmt91),cos(tmt91))*0.16;
      vec2 tangle42 = vec2(sin(tmt92),cos(tmt92))*0.16;
      vec2 tangle43 = vec2(sin(tmt93),cos(tmt93))*0.16;
      vec2 tangle44 = vec2(sin(tmt94),cos(tmt94))*0.16;
      vec2 tangle45 = vec2(sin(tmt95),cos(tmt95))*0.16;

      vec2 tangle51 = vec2(sin(tmt10),cos(tmt10))*0.17;
      vec2 tangle52 = vec2(sin(tmt11),cos(tmt11))*0.17;
      vec2 tangle53 = vec2(sin(tmt12),cos(tmt12))*0.17;

      vec2 pa  = p + a;
      vec2 pb  = p + b;
      vec2 pc  = p + c;
      vec2 pd  = p + d;
      vec2 pe  = p + e;
      vec2 pf  = p + f;

      float lpa = length(pa);
      float lpb = length(pb);
      float lpc = length(pc);
      float lpd = length(pd);
      float lpe = length(pe);
      float lpf = length(pf);

      // Small central disc, innner circles and outer ring.

      q += disc ( lp, 0.005 )
         + ring ( lp, 0.200 )
         + ring ( lp, 0.100 )
         + ring ( lp, 0.180 )
         + ring ( lp, 1.000 );

      // The central rotating hexagon.

      q += line ( p,  tangle51, -tangle53 )
         + line ( p, -tangle51,  tangle53 )
         + line ( p,  tangle52,  tangle51 )
         + line ( p, -tangle52, -tangle51 )
         + line ( p,  tangle53,  tangle52 )
         + line ( p, -tangle53, -tangle52 );

      // Small discs at the vertices of the hexagon.

      q += disc ( length(p+tangle51), 0.010 )
         + disc ( length(p-tangle51), 0.010 )
         + disc ( length(p+tangle52), 0.010 )
         + disc ( length(p-tangle52), 0.010 )
         + disc ( length(p+tangle53), 0.010 )
         + disc ( length(p-tangle53), 0.010 );

      // Central vertical line.

      q += line ( p, p8, p7 )
         + disc ( length(p+p8), 0.005 )
         + disc ( length(p+p9), 0.005 );

      // Left and right semi-circles.

      q += (p.x < 0.0) ?  ring(lp,0.460) : ring(lp,0.400)+ring(lp,0.420);

      // Discs on the left hand semi-circle.

      q += disc ( length(p+p1), 0.020 )
         + disc ( length(p+p2), 0.020 )
         + disc ( length(p+p3), 0.020 )
         + disc ( length(p+p4), 0.020 )
         + disc ( length(p+p5), 0.020 );

      // Moving feature A

      q += disc ( lpa, 0.040 )
         + ring ( lpa, 0.100 )
         + ring ( lpa, 0.140 )
         + ring ( lpa, 0.200 )
         + disc ( length(pa+tangle3), 0.025 );

      // Moving feature B

      q += disc ( lpb, 0.005 )
         + ring ( lpb, 0.030 )
         + ring ( lpb, 0.150 )
         + ring ( lpb, 0.200 )
         + ring ( lpb, 0.450 );
         + disc ( length(pb+tangle1*0.05), 0.010 )
         + disc ( length(pb+tangle1*0.09), 0.020 )
         + disc ( length(pb+tangle1*0.15), 0.030 )
         + ring ( length(pb-tangle1*0.15), 0.030 )
         + ring ( length(pb-tangle1*0.07), 0.015 );

      // Moving features C

      q += ring ( lpc, 0.080 )
         + disc ( lpc, 0.005 );

      // Moving features D

      q += ring ( lpd, 0.080 )
         + disc ( lpd, 0.005 );

      // Moving feature E

      q += disc ( lpe, 0.005 )
         + ring ( lpe, 0.120 )
         + ring ( lpe, 0.100 )
         + disc ( length(pe+p6),           0.005 )
         + disc ( length(pe+tangle2*0.05), 0.010 )
         + disc ( length(pe+tangle2*0.10), 0.010 )
         + ring ( length(pe-tangle2*0.03), 0.010 );

      // Moving feature F

      q += ring ( lpf, 0.05 )
         + ring ( lpf, 0.10 )
         + ring ( lpf, 0.17 )
         + ring ( lpf, 0.20 )
         + disc ( length(pf+angle1a),  0.020 )
         + disc ( length(pf+tangle41), 0.010 )
         + disc ( length(pf+tangle42), 0.010 )
         + disc ( length(pf+tangle43), 0.010 )
         + disc ( length(pf-tangle43), 0.010 )
         + disc ( length(pf+tangle44), 0.010 )
         + disc ( length(pf+tangle45), 0.010 );


      // Lines connecting the various moving features.

      q += line ( p, p0,             a    )
         + line ( p, b,              a    )
         + line ( p, c,              d    )
         + line ( p, b+tangle1*0.15, d    )
         + line ( p, d,              e+p6 )
         + line ( p, angle1a,        e    )
         + line ( p, f-tangle43,     c    )
         + line ( p, f+tangle42,     d    );

    }

   // Output the pixel.

   gl_FragColor = vec4 ( colour*q, q );

   // For debuging you can highlight components using code like this:-
   // if ( ring ( lpf, 0.20 ) ) gl_FragColor.rgb = vec3(1.0,0.0,0.0);


}